
/* VARIABLES USED IN REGRESSIONS CODE:
lpo: LoanValues 
ptpno: Participation
bnpl: Borrower CPRisk
lnpl: Lender CPRisk
bsfln: Borrower Collateral
lsfln: Lender Collateral
bis: LB, i.e. indicator for post-Lehman Brothers default
lbspos: binary variable indicating borrower-lender-market unit had positive loans outstanding in sample
sec (or s): 1(s), i.e. indicator for the repo market
br: factor variable for borrowers
ln: factor variable for lenders
day: factor variable for date
bf: indicator for if borrower is foreign
lf: indicator for if lender is foreign
td: TED spread lagged one day.
UNDERSCORES BETWEEN VARIABLE NAMES REPRESENT INTERACTIONS.
*/

clear all

ssc install reghdfe
ssc install tuples
ssc install estout

cd "[FOLDER PATH]"
import delimited using "[DATA FILE]"

set more off

/* Convert variables from string to integer */
encode lnd, generate(ln)
encode brw, generate(br)

rename sd day
rename bdspos lbspos
gen const = day > 0

//gen bishock = day >= 38975
gen bishock = day >= 38978
order bishock, after(tdp)

// Remove NAs and replace wwith missing value, first force variables to string to 
//   make it easier.
foreach v of varlist spr_out-bishock {
	tostring `v', force replace
	replace `v' = "." if `v' == "NA" | `v' == "-Inf" | `v' == "Inf"
}
destring, replace

// Remove public holiday day
replace princ_out = . if day == 38992

replace bcgs = bcgs / 1000000000
replace bsgs = bsgs / 1000000000
replace lcgs = lcgs / 1000000000
replace lsgs = lsgs / 1000000000

/* geenrate and format the sec holdings variables */
generate lsfln = ln(lcgs + lsg + 1)
generate lsgln = ln(lsgs + 1)
generate lcgln = ln(lcgs + 1)
generate bsfln = ln(bcgs + bsgs + 1)
generate bsgln = ln(bsgs + 1)
generate bcgln = ln(bcgs + 1)
generate lsf = lcgs + lsgs
generate bsf = bcgs + bsgs
order lsfln-lcgln, after(lcgs)
order bsfln-bcgln, after(bcgs)

egen new_brw = tag(brw)
egen new_lnd = tag(lnd)
// Standardise the main variables
foreach v of varlist blev bsz bsgln bcgln { // Remvoed bnpl and bsfln and did them below
	egen `v'mn = mean(`v') if new_brw == 1
	replace `v'mn = `v'mn[_n-1] if `v'mn == .
	egen `v'sd = sd(`v') if new_brw == 1
	replace `v'sd = `v'sd[_n-1] if `v'sd == .
	replace `v' = (`v' - `v'mn) / `v'sd
}

egen bnpl_mn = mean(bnpl) if new_brw == 1
replace bnpl_mn = bnpl_mn[_n-1] if bnpl_mn == .
egen bnpl_sd = sd(bnpl) if new_brw == 1
replace bnpl_sd = bnpl_sd[_n-1] if bnpl_sd == .
replace bnpl = (bnpl - bnpl_mn)/0.9522523

egen bsfln_mn = mean(bsfln) if new_brw == 1
replace bsfln_mn = bsfln_mn[_n-1] if bsfln_mn == .
egen bsfln_sd = sd(bsfln) if new_brw == 1
replace bsfln_sd = bsfln_sd[_n-1] if bsfln_sd == .
replace bsfln = (bsfln - bsfln_mn)/0.5821091


// Now the lednder variables
foreach v of varlist lnpl {
	egen `v'mn = mean(`v') if new_lnd == 1
	replace `v'mn = `v'mn[_n-1] if `v'mn == .
	egen `v'sd = sd(`v') if new_brw == 1
	replace `v'sd = `v'sd[_n-1] if `v'sd == .
	replace `v' = (`v' - `v'mn) / `v'sd

}
foreach v of varlist lsfln lsgln lcgln {
	egen `v'mn = mean(`v') if new_lnd == 1
	replace `v'mn = `v'mn[_n-1] if `v'mn == .
	egen `v'sd = sd(`v') if new_brw == 1
	replace `v'sd = `v'sd[_n-1] if `v'sd == .
	replace `v' = `v' / `v'sd

}

/* different forms of the DV */
generate po = princ_out / 1000000
generate lpo = ln(po+1)
generate ptpno = (lpo>0)
replace ptpno = . if lpo == .

foreach v of varlist lsgs-lcgln {
	generate bis_`v' = bishock*`v'
	generate s_`v' = sec*`v'
	generate `v'_lnpl = `v'*lnpl
	generate s_`v'_lnpl = sec*`v'*lnpl
	generate s_bis_`v' = sec*bishock*`v'
	generate bis_`v'_lnpl = bishock*`v'*lnpl
	generate s_bis_`v'_lnpl = sec*bishock*`v'*lnpl
}
generate s_lnpl = sec*lnpl

foreach v of varlist bsgs-bcgln {
	generate bis_`v' = bishock*`v'
	generate s_`v' = sec*`v'
	generate `v'_bnpl = `v'*bnpl
	generate s_`v'_bnpl = sec*`v'*bnpl
	generate s_bis_`v' = sec*bishock*`v'
	generate bis_`v'_bnpl =  bishock*`v'*bnpl
	generate s_bis_`v'_bnpl = sec*bishock*`v'*bnpl
}

generate s_bis = sec*bishock
generate s_bnpl = sec*bnpl
generate s_bis_bnpl = sec*bishock*bnpl
generate bis_bnpl = bishock*bnpl
generate bis_lnpl = bishock*lnpl


// TABLE B2 - PLACEBO REGRESSIONS
quietly reghdfe lpo bis_bnpl bis_bsfln bis_bsfln_bnpl if lbspos > 0 & sec == 0, absorb(br ln#day) vce(cluster br ln day)
estimates store m1, title("Unsecured")
quietly reghdfe ptpno bis_bnpl bis_bsfln bis_bsfln_bnpl if lbspos > 0 & sec == 0, absorb(br ln#day) vce(cluster br ln day)
estimates store m2, title("Unsecured")
quietly reghdfe lpo bis_bnpl bis_bsfln bis_bsfln_bnpl if lbspos > 0 & sec == 1, absorb(br ln#day) vce(cluster br ln day)
estimates store m3, title("Secured")
quietly reghdfe ptpno bis_bnpl bis_bsfln bis_bsfln_bnpl if lbspos > 0 & sec == 1, absorb(br ln#day) vce(cluster br ln day)
estimates store m4, title("Secured")
esttab m1 m2 m3 m4 /*using sep06plac.tex*/, mtitles ///
cells(b(star fmt(3)) se(par fmt(3))) legend starlevels(* 0.1 ** 0.05 *** 0.01) varwidth(12) modelwidth(10) r2 

quietly reghdfe lpo sec s_bsfln s_bnpl s_bsfln_bnpl s_bis s_bis_bsfln s_bis_bnpl s_bis_bsfln_bnpl if sec >= 0, ///
absorb(br#ln#day) vce(cluster br ln day)
estimates store m1, title("value")
quietly reghdfe ptpno sec s_bsfln s_bnpl s_bsfln_bnpl s_bis s_bis_bsfln s_bis_bnpl s_bis_bsfln_bnpl if sec >= 0, ///
absorb(br#ln#day) vce(cluster br ln day)
estimates store m2, title("ptpn")
esttab m1 m2 /*using placbrwsub.tex*/, mtitles ///
cells(b(star fmt(3)) se(par fmt(3))) legend starlevels(* 0.1 ** 0.05 *** 0.01) varwidth(30) modelwidth(10) r2 ///
keep(s_bis_bnpl s_bis_bsfln s_bis_bsfln_bnpl)

quietly reghdfe lpo bis_lnpl bis_lsfln bis_lsfln_lnpl if lbspos > 0 & sec == 0, absorb(ln br#day) vce(cluster br ln day)
estimates store m1, title("Unsecured")
quietly reghdfe ptpno bis_lnpl bis_lsfln bis_lsfln_lnpl if lbspos > 0 & sec == 0, absorb(ln br#day) vce(cluster br ln day)
estimates store m2, title("Unsecured")
quietly reghdfe lpo bis_lnpl bis_lsfln bis_lsfln_lnpl if lbspos > 0 & sec == 1, absorb(ln br#day) vce(cluster br ln day)
estimates store m3, title("Secured")
quietly reghdfe ptpno bis_lnpl bis_lsfln bis_lsfln_lnpl if lbspos > 0 & sec == 1, absorb(ln br#day) vce(cluster br ln day)
estimates store m4, title("Secured")
esttab m1 m2 m3 m4 /*using seplnd06plac.tex*/, mtitles ///
cells(b(star fmt(3)) se(par fmt(3))) legend starlevels(* 0.1 ** 0.05 *** 0.01) varwidth(12) modelwidth(10) ///
r2 title("LPO regressions, brw*lnd day FE, brw lnd day clustering") 
